'use client';

import React from 'react';
import { useDatabaseContext } from '@/lib/context/DatabaseContext';
import { HostConfig, DatabaseConfig, TableConfig } from '@/lib/config/databases';

export default function DatabaseSelector() {
  const {
    currentHostId,
    currentDatabaseName,
    currentTableName,
    setCurrentHostId,
    setCurrentDatabaseName,
    setCurrentTableName,
    availableHosts,
    availableDatabases,
    availableTables,
  } = useDatabaseContext();

  return (
    <div className="flex flex-col sm:flex-row gap-2 mb-4">
      <div className="w-full sm:w-1/3">
        <label htmlFor="host-select" className="block text-sm font-medium text-gray-700 mb-1">
          Host
        </label>
        <select
          id="host-select"
          className="w-full rounded-md border border-gray-300 py-2 px-3 text-sm shadow-sm focus:border-blue-500 focus:outline-none focus:ring-1 focus:ring-blue-500"
          value={currentHostId}
          onChange={(e) => setCurrentHostId(e.target.value)}
        >
          {availableHosts.map((host: HostConfig) => (
            <option key={host.hostId} value={host.hostId}>
              {host.displayName}
            </option>
          ))}
        </select>
      </div>
      
      <div className="w-full sm:w-1/3">
        <label htmlFor="database-select" className="block text-sm font-medium text-gray-700 mb-1">
          Database
        </label>
        <select
          id="database-select"
          className="w-full rounded-md border border-gray-300 py-2 px-3 text-sm shadow-sm focus:border-blue-500 focus:outline-none focus:ring-1 focus:ring-blue-500"
          value={currentDatabaseName}
          onChange={(e) => setCurrentDatabaseName(e.target.value)}
        >
          {availableDatabases.map((database: DatabaseConfig) => (
            <option key={database.databaseName} value={database.databaseName}>
              {database.displayName}
            </option>
          ))}
        </select>
      </div>
      
      <div className="w-full sm:w-1/3">
        <label htmlFor="table-select" className="block text-sm font-medium text-gray-700 mb-1">
          Table
        </label>
        <select
          id="table-select"
          className="w-full rounded-md border border-gray-300 py-2 px-3 text-sm shadow-sm focus:border-blue-500 focus:outline-none focus:ring-1 focus:ring-blue-500"
          value={currentTableName}
          onChange={(e) => setCurrentTableName(e.target.value)}
        >
          {availableTables.map((table: TableConfig) => (
            <option key={table.tableName} value={table.tableName}>
              {table.displayName}
            </option>
          ))}
        </select>
      </div>
    </div>
  );
}
