/**
 * Hardcoded exact FileMaker field names
 * These are the actual database field names to be used in the application
 */

// Clients table field names
export const clientsFields = [
  '_HOT_g',
  'Category',
  'cl_id',
  'Company',
  'Email',
  'IM',
  'me',
  'Name',
  'Name_id',
  'Nickname',
  'Notes',
  'NoteType',
  'Phone',
  'Project_ID',
  'Project_ID_Title',
  'rate',
  'shortname',
  'Status',
  'Web',
  'web_pass',
  'z_chart_count',
  'z_chart_total',
  'z_chart_types',
  'z_recid',
  'zGlobal',
  'zTMPID',
];

// TrackPad table field names
export const trackPadFields = [
  '_apMod_end',
  '_apMod_start',
  '_Constant',
  '_FileName',
  '_gAction',
  '_gCat_u',
  '_gDate',
  '_gEnd_AP',
  '_gEnd_Calc',
  '_gEnd_H',
  '_gEnd_M',
  '_gID_Prj',
  '_gID_Task',
  '_gID_TT',
  '_gLayout',
  '_gName_u',
  '_gPhrase_u',
  '_gPrjStatus YUMMM',
  '_gPrjStatusActive',
  '_gPrjStatusChoice',
  '_gProj_u',
  '_gQuery_cal',
  '_gQuery_kban',
  '_gStart_AP',
  '_gStart_Calc',
  '_gStart_H',
  '_gStart_M',
  '_gTopic_u',
  '_gVar1',
  '_gVar2',
  '_gVar3',
  '_gVar4',
  '_gVar5',
  '_gVarRESPONSE',
  '_gYear',
  '_HOT_g',
  '_platform',
  '_sub_Amount',
  '_sub_LenTime',
  '_sub_pl_Hours',
  '_sub_recCount',
  '_Var3cont_g',
  'Arc',
  'cal_all_day',
  'calendar_id',
  'category_c',
  'Company',
  'CountAvg',
  'DateWeek',
  'DateWeekDay',
  'DateWeekDayFMTmpToss',
  'DateWeekEnd',
  'DateWeekStart',
  'destination_c',
  'EndDate',
  'EndTime',
  'EndTime_cal',
  'Format',
  'Frequency',
  'Hours',
  'LenTime',
  'LenTime_show',
  'Media1',
  'Media2',
  'MediaName1',
  'MediaName2',
  'MediaType1',
  'MediaType2',
  'Message',
  'Message_xp',
  'miles_biz',
  'miles_end',
  'miles_personal',
  'miles_start',
  'Name',
  'Name_id',
  'NoteType',
  'NoteType_c',
  'Phase',
  'pl_Amount',
  'pl_Cat',
  'pl_Number',
  'pl_Order',
  'pl_Pri',
  'pl_Rate',
  'pl_Source',
  'pl_Status',
  'pl_Status_BACKUPTMP',
  'pl_Status_calc',
  'pl_Topic',
  'pl_zModDate',
  'pl_zModDate_reminder',
  'pl_zStampDate',
  'pl_zStampDate_reminder',
  'Proj_Focus',
  'proj_id',
  'Proj_Title',
  'project_c',
  'prompt_01',
  'rem_Completion Date',
  'rem_Creation Date',
  'rem_Due Date',
  'rem_File Size',
  'rem_Has Alarms',
  'rem_Has Sub Tasks',
  'rem_Image',
  'rem_Is Completed',
  'rem_Is Flagged',
  'rem_Last Modified Date',
  'rem_List',
  'rem_Name',
  'rem_Notes',
  'rem_Parent Reminder',
  'rem_Priority',
  'rem_Reminder Location',
  'rem_Subtasks',
  'rem_Title',
  'rem_URL',
  'res_01',
  'res_01_id',
  'res_02',
  'res_02_status',
  'res_03',
  'res_fm',
  'response_last_message',
  'response_last_response',
  'response_last_response_oai',
  'response_pretty_all',
  'response_pretty_last',
  'response_pretty_last_all',
  'Send Date',
  'sent_count',
  'shortname',
  'show_line',
  'show_line_cal',
  'show_line_short',
  'Star_nah',
  'StartDate',
  'StartDate_c',
  'StartTime',
  'starttime_c',
  'StartTime_cal',
  'starttime24_c',
  'Status',
  'ts_sent',
  'tsk_id',
  'tsk_id new for planner',
  'tsk_id orig temp bu',
  'tt_id',
  'txt_01',
  'txt_01_c',
  'x_line',
  'x_line_js',
  'z_Age',
  'z_chart_clients',
  'z_chart_count',
  'z_chart_count sum',
  'z_chart_total',
  'z_chart_total sum',
  'z_chart_types',
  'z_chart_types sum',
  'z_ctLines',
  'z_ctPg',
  'z_ctRecs',
  'z_ctWord',
  'z_FilePathLoc',
  'z_FilePathLoc_c',
  'z_FilePathName',
  'z_Found',
  'z_foundNum',
  'z_jsonrec',
  'z_kbSort',
  'z_kbStatus',
  'z_Layout_Info',
  'z_MON_c',
  'z_recid',
  'z_Source',
  'z_Source_g',
  'z_YR_c',
  'z_YR_MON_c',
  'zCatOrder_c',
  'zGlobal',
  'zResponse',
  'zResponsePretty',
];

// Common fields that are important for most operations
export const commonFields = {
  id: 'z_recid',
  name: 'Name',
  dateCreated: 'DateCreated',
  status: 'Status',
};

// Important fields for TrackPad table
export const trackPadImportantFields = [
  'z_recid',
  'Name',
  'StartDate',
  'StartTime',
  'EndTime',
  'LenTime',
  'Message',
  'NoteType',
  'pl_Status',
  'pl_Cat',
  'proj_id',
  'tsk_id',
];

// Important fields for Clients table
export const clientsImportantFields = [
  'z_recid',
  'Name',
  'Email',
  'Phone',
  'Company',
  'Notes',
  'Status',
];

// Mobile display fields for Clients - optimized for small screens
export const clientsMobileFields = [
  'Name',
  'Company',
  'Status'
] as const;

// Mobile field labels mapping for Clients
export const clientsMobileLabels: Record<string, string> = {
  'Name': 'Client',
  'Company': 'Company',
  'Status': 'Status',
  'CreatedDate': 'Created',
  'ModifiedDate': 'Updated'
};

// Display fields for Clients list view
export const clientsDisplayFields = [
  'Name',
  'Company',
  'Status',
  'z_recid'
];

// Fields that should be editable in TrackPad
export const trackPadEditableFields = [
  'Name',
  'StartDate',
  'StartTime',
  'EndTime',
  'LenTime',
  'Message',
  'NoteType',
  'pl_Status',
  'pl_Cat',
  'proj_id',
  'tsk_id',
];

// Fields that should be editable in Clients
export const clientsEditableFields = [
  'Name',
  'Email',
  'Phone',
  'Company',
  'Notes',
  'Status',
];



// Short display fields for TrackPad (tasks-all) - for task list view
export const trackPadDisplayAll = [
  'Name',
  'Message',
  'StartDate',
  'StartTime',
  'EndTime',
  'pl_Status',
  'pl_Cat',
  'pl_Topic',
  'z_recid'
];



// Short display fields for TrackPad (tasks) - for task list view
export const trackPadDisplayShort = [
  'Message',
  'StartDate',
  'StartTime',
  'EndTime',
  'pl_Status',
  'pl_Cat',
  'pl_Topic',
  'z_recid'
];

// Full display fields for TrackPad (tasks) - for detailed task view
export const trackPadDisplayFull = [
  'Message',
  'Name',
  'StartDate',
  'StartTime',
  'EndTime',
  'LenTime',
  'NoteType',
  'pl_Status',
  'pl_Cat',
  'pl_Topic',
  'DateDue',
  'z_recid'
];

// Mobile display fields for TrackPad - optimized for small screens
// These fields should match the mobileLabels in tasks/page.tsx
export const trackPadDisplayMobile = [
  'Message',
  'NoteType',
  'StartDate',
  'pl_Status',
  'pl_Cat',
  'z_recid'
];

// Short display fields for Clients - for client list view
export const clientsDisplayShort = [
  'Name',
  'Company',
  'Notes',
  'Status',
  'z_recid',
];

// Full display fields for Clients - for detailed client view
export const clientsDisplayFull = [
  'z_recid',
  'Name',
  'Email',
  'Phone',
  'Company',
  'Notes',
  'Status'
];
